#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
	[TestFixture]
	public class DAL_OrderedComponent : BaseTest 
	{

		private DataTable _dtOrderedComponent;
		

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtOrderedComponent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 OC.*, PO.OrderReceivedDateTime, PO.OrderGroupNumber, PT.PatientGuid FROM OrderedComponent OC JOIN PatientOrder PO ON PO.PatientOrderGuid = OC.PatientOrderGuid AND PO.OrderGroupNumber IS NOT NULL JOIN PatientTreatment PT ON PT.PatientTreatmentGuid = PO.PatientTreatmentGuid WHERE OC.OrderStatusCode = 'A' AND OC.TaskStatusCode IN ('I','F','P','N','R') AND OC.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}
		}


		[Test]
		public void GetComponentTaskList_Pass()
		{
			DataTable dtTest = DAL.OrderedComponent.GetComponentTaskList(string.Empty);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(56, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderUrgency.OrderUrgencyText), TABLES.OrderUrgency.OrderUrgencyText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderUrgencyCode), TABLES.OrderedComponent.OrderUrgencyCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderedComponentGuid), TABLES.OrderedComponent.OrderedComponentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderedComponentComments), TABLES.OrderedComponent.OrderedComponentComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.SpecimenAccessionNumber), TABLES.OrderedComponent.SpecimenAccessionNumber);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.SpecimenWorkloadUid), TABLES.OrderedComponent.SpecimenWorkloadUid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.SpecimenRequiredIndicator), TABLES.OrderedComponent.SpecimenRequiredIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.LabTestId), TABLES.OrderedComponent.LabTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.PatientSpecimenGuid), TABLES.OrderedComponent.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.InappropriateRequestIndicator), TABLES.OrderedComponent.InappropriateRequestIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.RowVersion), TABLES.OrderedComponent.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientGuid), TABLES.Patient.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientLocation), TABLES.PatientTreatment.PatientLocation);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.BloodTypeCode), TABLES.Patient.BloodTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.RhFactorCode), TABLES.Patient.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientTreatingFacility), TABLES.PatientTreatment.PatientTreatingFacility);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientAdmittingDiagnosis), TABLES.PatientTreatment.PatientAdmittingDiagnosis);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientTreatmentGuid), TABLES.PatientTreatment.PatientTreatmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientServiceBranch), TABLES.Patient.PatientServiceBranch);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.PatientOrderGuid), TABLES.PatientOrder.PatientOrderGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderFirstName), TABLES.PatientOrder.OrderingProviderFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderLastName), TABLES.PatientOrder.OrderingProviderLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderMiddleInitial), TABLES.PatientOrder.OrderingProviderMiddleInitial);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredByFirstName), TABLES.PatientOrder.OrderEnteredByFirstName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredByLastName), TABLES.PatientOrder.OrderEnteredByLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderReceivedDatetime), TABLES.PatientOrder.OrderReceivedDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderPlacedDatetime), TABLES.PatientOrder.OrderPlacedDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.SurgeryName), TABLES.PatientOrder.SurgeryName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.RequestReason), TABLES.PatientOrder.RequestReason);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderComments), TABLES.PatientOrder.OrderComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingHospitalLocation), TABLES.PatientOrder.OrderingHospitalLocation);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.InformedConsentIndicator), TABLES.PatientOrder.InformedConsentIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), TABLES.PatientSpecimen.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenUid), TABLES.PatientSpecimen.SpecimenUid);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenExpirationDate), TABLES.PatientSpecimen.SpecimenExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassShortName), TABLES.ComponentClass.ComponentClassShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.RequiredUnitQuantity), TABLES.OrderedComponent.RequiredUnitQuantity);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.RequiredDatetime), TABLES.OrderedComponent.RequiredDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderedComponentComments), TABLES.OrderedComponent.OrderedComponentComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderSpecialInstructions), TABLES.OrderedComponent.OrderSpecialInstructions);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.CprsOrderNumber), TABLES.OrderedComponent.CprsOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.VbecsOrderNumber), TABLES.OrderedComponent.VbecsOrderNumber);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.DivisionCode), TABLES.OrderedComponent.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TaskStatus.TaskStatusText), TABLES.TaskStatus.TaskStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.TaskStatusCode), TABLES.OrderedComponent.TaskStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderUrgency.SortColumn), TABLES.OrderUrgency.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderGroupNumber), TABLES.PatientOrder.OrderGroupNumber);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TreatingSpecialty.TreatingSpecialtyName), TABLES.TreatingSpecialty.TreatingSpecialtyName);
		}

		[Test]
		public void GetComponentTaskList_Fail()
		{
			DataTable dtTest = DAL.OrderedComponent.GetComponentTaskList("Homerpalooza");

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetComponentOrders_Pass()
		{
			DataTable dtTest = DAL.OrderedComponent.GetComponentOrders();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(56, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.PatientOrderGuid), TABLES.PatientOrder.PatientOrderGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderGroupNumber), TABLES.PatientOrder.OrderGroupNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.LabOrderNumber), TABLES.OrderedComponent.LabOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderFirstName), TABLES.PatientOrder.OrderingProviderFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderLastName), TABLES.PatientOrder.OrderingProviderLastName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredByFirstName), TABLES.PatientOrder.OrderEnteredByFirstName);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredByLastName), TABLES.PatientOrder.OrderEnteredByLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderComments), TABLES.PatientOrder.OrderComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingHospitalLocation), TABLES.PatientOrder.OrderingHospitalLocation);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.InformedConsentIndicator), TABLES.PatientOrder.InformedConsentIndicator);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.SurgeryName), TABLES.PatientOrder.SurgeryName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.RequestReason), TABLES.PatientOrder.RequestReason);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderReceivedDatetime), TABLES.PatientOrder.OrderReceivedDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.BloodTypeCode), TABLES.Patient.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.RhFactorCode), TABLES.Patient.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientGuid), TABLES.Patient.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientTreatingFacility), TABLES.PatientTreatment.PatientTreatingFacility);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientAdmittingDiagnosis), TABLES.PatientTreatment.PatientAdmittingDiagnosis);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientRoomBed), TABLES.PatientTreatment.PatientRoomBed);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientLocation), TABLES.PatientTreatment.PatientLocation);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TreatingSpecialty.TreatingSpecialtyName), TABLES.TreatingSpecialty.TreatingSpecialtyName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientServiceBranch), TABLES.Patient.PatientServiceBranch);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.VbecsOrderNumber), TABLES.OrderedComponent.VbecsOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), TABLES.PatientSpecimen.PatientSpecimenGuid);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.SpecimenRequiredIndicator), TABLES.OrderedComponent.SpecimenRequiredIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.SpecimenStatusCode), TABLES.OrderedComponent.SpecimenStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderedComponentGuid), TABLES.OrderedComponent.OrderedComponentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.CprsOrderNumber), TABLES.OrderedComponent.CprsOrderNumber);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.PreOpIndicator), TABLES.OrderedComponent.PreOpIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.RequiredUnitQuantity), TABLES.OrderedComponent.RequiredUnitQuantity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderUrgencyCode), TABLES.OrderedComponent.OrderUrgencyCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.RequiredDatetime), TABLES.OrderedComponent.RequiredDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderedComponentComments), TABLES.OrderedComponent.OrderedComponentComments);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderSpecialInstructions), TABLES.OrderedComponent.OrderSpecialInstructions);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderStatusCode), TABLES.OrderedComponent.OrderStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.DivisionCode), TABLES.OrderedComponent.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.LabOrderNumber), TABLES.OrderedComponent.LabOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.LabTestId), TABLES.OrderedComponent.LabTestId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassShortName), TABLES.ComponentClass.ComponentClassShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderUrgency.OrderUrgencyText), TABLES.OrderUrgency.OrderUrgencyText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenStatus.SpecimenStatusCode), TABLES.SpecimenStatus.SpecimenStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenStatus.SpecimenStatusText), TABLES.SpecimenStatus.SpecimenStatusText);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderStatus.OrderStatusText), TABLES.OrderStatus.OrderStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenUid), TABLES.PatientSpecimen.SpecimenUid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.RowVersion), TABLES.OrderedComponent.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.DatabaseConstants.ArtificialColumnNames.UrgencySortColumn), Common.DatabaseConstants.ArtificialColumnNames.UrgencySortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.DatabaseConstants.ArtificialColumnNames.RequestSortColumn), Common.DatabaseConstants.ArtificialColumnNames.RequestSortColumn);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetComponentOrders_Fail()
		{
		}

		[Test]
		public void GetRecentComponentOrders_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtOrderedComponent.Rows[0][TABLES.OrderedComponent.OrderedComponentGuid];

			DataSet dsTest = DAL.OrderedComponent.GetRecentComponentOrders(unitGuid);

			Assert.AreEqual(2, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(19, dsTest.Tables[0].Columns.Count, "Tables[0].Count");

			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.OrderedComponent.OrderedComponentGuid), "[0] -" + TABLES.OrderedComponent.OrderedComponentGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.OrderedComponent.PatientOrderGuid), "[0] -" + TABLES.OrderedComponent.PatientOrderGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.PatientOrder.OrderReceivedDatetime), "[0] -" + TABLES.PatientOrder.OrderReceivedDatetime);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.OrderedComponent.ComponentClassId), "[0] -" + TABLES.OrderedComponent.ComponentClassId);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ComponentClass.ComponentClassShortName), "[0] -" + TABLES.ComponentClass.ComponentClassShortName);

			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.ComponentClass.ComponentClassName), "[0] -" + TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.OrderedComponent.RequiredUnitQuantity), "[0] -" + TABLES.OrderedComponent.RequiredUnitQuantity);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.OrderedComponent.RequiredDatetime), "[0] -" + TABLES.OrderedComponent.RequiredDatetime);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.OrderedComponent.CprsOrderNumber), "[0] -" + TABLES.OrderedComponent.CprsOrderNumber);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.OrderedComponent.OrderSpecialInstructions), "[0] -" + TABLES.OrderedComponent.OrderSpecialInstructions);

			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.OrderedComponent.OrderStatusCode), "[0] -" + TABLES.OrderedComponent.OrderStatusCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.OrderStatus.OrderStatusText), "[0] -" + TABLES.OrderStatus.OrderStatusText);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.OrderedComponent.TaskStatusCode), "[0] -" + TABLES.OrderedComponent.TaskStatusCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.TaskStatus.TaskStatusText), "[0] -" + TABLES.TaskStatus.TaskStatusText);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.OrderedComponent.OrderedComponentComments), "[0] -" + TABLES.OrderedComponent.OrderedComponentComments);

			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.OrderedComponent.DivisionCode), "[0] -" + TABLES.OrderedComponent.DivisionCode);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.VamcDivision.DivisionName), "[0] -" + TABLES.VamcDivision.DivisionName);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), "[0] -" + TABLES.PatientSpecimen.PatientSpecimenGuid);
			Assert.AreEqual(true, dsTest.Tables[0].Columns.Contains(TABLES.PatientSpecimen.SpecimenUid), "[0] -" + TABLES.PatientSpecimen.SpecimenUid);


			Assert.AreEqual(22, dsTest.Tables[1].Columns.Count, "Tables[1].Count");

			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.OrderedUnit.OrderedUnitGuid), "[1] -" + TABLES.OrderedUnit.OrderedUnitGuid);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.OrderedUnit.CrossmatchDate), "[1] -" + TABLES.OrderedUnit.CrossmatchDate);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.OrderedUnit.CrossmatchResultCode), "[1] -" + TABLES.OrderedUnit.CrossmatchResultCode);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.OrderedComponent.OrderedComponentGuid), "[1] -" + TABLES.OrderedComponent.OrderedComponentGuid);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), "[1] -" + TABLES.BloodUnit.BloodUnitGuid);

			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), "[1] -" + TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodUnit.UnitProductCode), "[1] -" + TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodUnit.BloodProductGuid), "[1] -" + TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodProduct.ProductShortName), "[1] -" + TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), "[1] -" + TABLES.BloodUnitMedia.BloodTypeCode);

			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), "[1] -" + TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), "[1] -" + TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodUnit.DonationTypeId), "[1] -" + TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.DonationType.DonationTypeText), "[1] -" + TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), "[1] -" + TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);

			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), "[1] -" + TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), "[1] -" + TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodUnit.DivisionCode), "[1] -" + TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodUnit.LabelTypeCode), "[1] -" + TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.IssuedUnit.IssueToLocationName), "[1] -" + TABLES.IssuedUnit.IssueToLocationName);

			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.BloodUnit.UnitDivisionId), "[1] -" + TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dsTest.Tables[1].Columns.Contains(TABLES.DonationType.DonationTypeCode), "[1] -" + TABLES.DonationType.DonationTypeCode);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetRecentComponentOrders_Fail()
		{
			DAL.OrderedComponent.GetRecentComponentOrders(System.Guid.Empty);
		}

		[Test]
		public void GetRecentComponentOrdersCount_Pass()
		{
			System.Guid patientGuid;

			string sSQL = "SELECT "; 
			sSQL+="TOP 1 pt.PatientGuid "; 
			sSQL+="FROM ";
			sSQL+="		OrderedComponent oc ";
			sSQL+="JOIN ";
			sSQL+="		PatientOrder po ON oc.PatientOrderGuid=po.PatientOrderGuid ";
			sSQL+="JOIN ";
			sSQL+="		PatientTreatment pt ON pt.PatientTreatmentGuid=po.PatientTreatmentGuid ";
			sSQL+="WHERE ";
			sSQL+="		oc.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND oc.PatientSpecimenGuid IS NOT NULL";

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable( sSQL, true );

			patientGuid = (System.Guid)dtTemp.Rows[0][TABLES.PatientTreatment.PatientGuid];

			Assert.IsTrue(DAL.OrderedComponent.GetRecentComponentOrdersCount(patientGuid)>=0);
		}

		[Test]
		[ExpectedException(typeof(System.ArgumentException))]
		public void GetRecentComponentOrdersCount_Fail()
		{
			Assert.IsTrue(DAL.OrderedComponent.GetRecentComponentOrdersCount(Guid.Empty)==0);
		}

		[Test]
		public void GetOrderableComponentClasses_Pass()
		{
			DataTable dtTest = DAL.OrderedComponent.GetOrderableComponentClasses();

			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderableComponentClasses_Fail()
		{
		}

		[Test]
		public void IsOrderedComponentPending_Pass()
		{
			DataCreator.CreateNewOrder(false);		//Creates CCID 1 
			bool retValue = DAL.OrderedComponent.IsOrderedComponentPending(1);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		public void IsOrderedComponentPending_Fail()
		{
			bool retValue = DAL.OrderedComponent.IsOrderedComponentPending(99);

			Assert.AreEqual(false, retValue, "ReturnValue");
		}


		[Test]
		public void UpdateStatus_Pass()
		{
			this.RefreshData = true;

			BOL.OrderedComponent tmpOC = new BOL.OrderedComponent(this._dtOrderedComponent.Rows[0]);

			DataTable updOC = SprocHelper.GetUpdateOrderedComponentStatusSprocTable(tmpOC.OrderedComponentGuid, tmpOC.RowVersion);

			BOL.ExceptionReport tmpER = new BOL.ExceptionReport(Common.ExceptionType.Emergency_issue_request, "UnitTest-" + System.DateTime.Now.ToString(), Common.LogonUser.LogonUserName);
			tmpER.ExceptionDate = System.DateTime.Now;
			tmpER.GenerateExceptionEmergencyIssueOrder(tmpOC);
			DataTable dtException = tmpER.ExceptionData.Table.Clone();
			DataRow drException = dtException.NewRow();
			foreach(DataColumn dc in dtException.Columns)
			{
				drException[dc.ColumnName] = tmpER.ExceptionData[dc.ColumnName];
			}
			dtException.Rows.Add(drException);

			Common.Utility.AppendLastUpdateInformation(updOC, Common.UpdateFunction.UnitTests);
			System.Guid [] orderGuids = new Guid[1];
			orderGuids[0] = tmpOC.OrderedComponentGuid;
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.AcceptOrder);
			DataTable dtWorkload = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.AcceptOrder, orderGuids, Common.WorkloadTransactionType.Miscellanious, false);

			//Add LastUpdateFunctionId --- this should probably be a parameter to GenerateWorkloadData to avoid having to code everywhere
			dtWorkload = Common.Utility.AppendLastUpdateInformation(dtWorkload, Common.UpdateFunction.UnitTests);

			bool retValue = DAL.OrderedComponent.UpdateStatus(updOC, dtException,dtWorkload );

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void UpdateStatus_Fail()
		{
			BOL.OrderedComponent tmpOC = new BOL.OrderedComponent(this._dtOrderedComponent.Rows[0]);

			DataTable updOC = SprocHelper.GetUpdateOrderedComponentStatusSprocTable(tmpOC.OrderedComponentGuid, new byte[8]);

			BOL.ExceptionReport tmpER = new BOL.ExceptionReport(Common.ExceptionType.Emergency_issue_request, "UnitTest-" + System.DateTime.Now.ToString(), Common.LogonUser.LogonUserName);
			tmpER.ExceptionDate = System.DateTime.Now;
			tmpER.GenerateExceptionEmergencyIssueOrder(tmpOC);
			DataTable dtException = tmpER.ExceptionData.Table.Clone();
			DataRow drException = dtException.NewRow();
			foreach(DataColumn dc in dtException.Columns)
			{
				drException[dc.ColumnName] = tmpER.ExceptionData[dc.ColumnName];
			}
			dtException.Rows.Add(drException);

			Common.Utility.AppendLastUpdateInformation(updOC, Common.UpdateFunction.UnitTests);
			System.Guid [] orderGuids = new Guid[1];
			orderGuids[0] = tmpOC.OrderedComponentGuid;
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.AcceptOrder);
			DataTable dtWorkload = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.AcceptOrder, orderGuids, Common.WorkloadTransactionType.Miscellanious, false);

			DAL.OrderedComponent.UpdateStatus(updOC, dtException, dtWorkload);
		}

		[Test]
		public void GetOrderData_Pass()
		{
			string cprsNumber = this._dtOrderedComponent.Rows[0][TABLES.OrderedComponent.CprsOrderNumber].ToString();

			DataSet dsTest = DAL.OrderedComponent.GetOrderData(cprsNumber);
			DataTable dtTest = dsTest.Tables[0];

			Assert.AreEqual(1, dsTest.Tables.Count, "Tables.Count");
			Assert.AreEqual(68, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.IsOrderedComponent), ARTIFICIAL.IsOrderedComponent);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientDob), TABLES.Patient.PatientDob);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSexCode), TABLES.Patient.PatientSexCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientIcn), TABLES.Patient.PatientIcn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.BloodTypeCode), TABLES.Patient.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.RhFactorCode), TABLES.Patient.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientNamePrefix), TABLES.Patient.PatientNamePrefix);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientNameSuffix), TABLES.Patient.PatientNameSuffix);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientDobCode), TABLES.Patient.PatientDobCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientLocation), TABLES.PatientTreatment.PatientLocation);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientRoomBed), TABLES.PatientTreatment.PatientRoomBed);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientAdmittingDiagnosis), TABLES.PatientTreatment.PatientAdmittingDiagnosis);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientServiceBranch), TABLES.Patient.PatientServiceBranch);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientTreatingFacility), TABLES.PatientTreatment.PatientTreatingFacility);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.InPatientIndicator), TABLES.PatientTreatment.InPatientIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.RecordStatusCode), TABLES.Patient.RecordStatusCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTreatment.PatientGuid), TABLES.PatientTreatment.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderLastName), TABLES.PatientOrder.OrderingProviderLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderFirstName), TABLES.PatientOrder.OrderingProviderFirstName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderMiddleInitial), TABLES.PatientOrder.OrderingProviderMiddleInitial);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderComments), TABLES.PatientOrder.OrderComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderPlacedDatetime), TABLES.PatientOrder.OrderPlacedDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.PatientOrderGuid), TABLES.PatientOrder.PatientOrderGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderGroupNumber), TABLES.PatientOrder.OrderGroupNumber);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderReceivedDatetime), TABLES.PatientOrder.OrderReceivedDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.LabOrderNumber), TABLES.OrderedComponent.LabOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderId), TABLES.PatientOrder.OrderingProviderId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingHospitalLocation), TABLES.PatientOrder.OrderingHospitalLocation);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredById), TABLES.PatientOrder.OrderEnteredById);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredByLastName), TABLES.PatientOrder.OrderEnteredByLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredByFirstName), TABLES.PatientOrder.OrderEnteredByFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderEnteredByMiddleInitial), TABLES.PatientOrder.OrderEnteredByMiddleInitial);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.RequestReason), TABLES.PatientOrder.RequestReason);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.InformedConsentIndicator), TABLES.PatientOrder.InformedConsentIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.SurgeryName), TABLES.PatientOrder.SurgeryName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.DivisionCode), TABLES.PatientOrder.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderedComponentGuid), TABLES.OrderedComponent.OrderedComponentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.ComponentClassId), TABLES.OrderedComponent.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.CprsOrderNumber), TABLES.OrderedComponent.CprsOrderNumber);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.VbecsOrderNumber), TABLES.OrderedComponent.VbecsOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.RequiredUnitQuantity), TABLES.OrderedComponent.RequiredUnitQuantity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.SpecimenRequiredIndicator), TABLES.OrderedComponent.SpecimenRequiredIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.PatientSpecimenGuid), TABLES.OrderedComponent.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.SpecimenStatusCode), TABLES.OrderedComponent.SpecimenStatusCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.PreOpIndicator), TABLES.OrderedComponent.PreOpIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderStatusCode), TABLES.OrderedComponent.OrderStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderUrgencyCode), TABLES.OrderedComponent.OrderUrgencyCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.RequiredDatetime), TABLES.OrderedComponent.RequiredDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderSpecialInstructions), TABLES.OrderedComponent.OrderSpecialInstructions);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderedComponentComments), TABLES.OrderedComponent.OrderedComponentComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.InappropriateRequestIndicator), TABLES.OrderedComponent.InappropriateRequestIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.TaskStatusCode), TABLES.OrderedComponent.TaskStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.CancellationCannedCommentGuid), TABLES.OrderedComponent.CancellationCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains("Expr4"), "Expr4");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassShortName), TABLES.ComponentClass.ComponentClassShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.CprsOrderableItemId), TABLES.ComponentClass.CprsOrderableItemId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.SortColumn), TABLES.ComponentClass.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderStatus.OrderStatusText), TABLES.OrderStatus.OrderStatusText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.CannedComment.CannedCommentText), TABLES.CannedComment.CannedCommentText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.LabOrderNumber), TABLES.OrderedComponent.LabOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.LabTestId), TABLES.OrderedComponent.LabTestId);
		}

		[Test]
		public void GetOrderData_Fail()
		{
			DataSet ds = DAL.OrderedComponent.GetOrderData(string.Empty);
			Assert.IsTrue(ds.Tables[0].Rows.Count == 0);
		}

		[Test]
		public void GetBloodUnitTestResultsForOrderedComponent_Guid_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtOrderedComponent.Rows[0][TABLES.OrderedComponent.OrderedComponentGuid];

			DataTable dtTest = DAL.OrderedComponent.GetBloodUnitTestResultsForOrderedComponent(unitGuid);

			Assert.AreEqual(27, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), TABLES.PatientSpecimen.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.OrderedComponentGuid), TABLES.BloodUnitTest.OrderedComponentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitTestGuid), TABLES.BloodUnitTest.BloodUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.OrderedUnitGuid), TABLES.BloodUnitTest.OrderedUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestingMethodCode), TABLES.BloodUnitTest.TestingMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.TestingMethodText), TABLES.TestingMethod.TestingMethodText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RackGuid), TABLES.BloodUnitTest.RackGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.TestedWith), TABLES.BloodTestType.TestedWith);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodTestTypeId), TABLES.BloodUnitTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), TABLES.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.Phase), TABLES.BloodTestType.Phase);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.SortColumn), TABLES.BloodTestType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestResultId), TABLES.BloodUnitTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestTechId), TABLES.BloodUnitTest.TestTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestDate), TABLES.BloodUnitTest.TestDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestComments), TABLES.BloodUnitTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.AutoInstrumentName), TABLES.BloodUnitTest.AutoInstrumentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RecordStatusCode), TABLES.BloodUnitTest.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.InactivateUser), TABLES.BloodUnitTest.InactivateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.InactivateDate), TABLES.BloodUnitTest.InactivateDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RowVersion), TABLES.BloodUnitTest.RowVersion);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PendingBloodUnitTest.UnitResultSetGuid), TABLES.PendingBloodUnitTest.UnitResultSetGuid);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetBloodUnitTestResultsForOrderedComponent_Guid_Fail()
		{
			DAL.OrderedComponent.GetBloodUnitTestResultsForOrderedComponent(System.Guid.Empty);
		}

		
		[Test]
		public void GetOrderedComponent_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtOrderedComponent.Rows[0][TABLES.OrderedComponent.OrderedComponentGuid];

			DataTable dtTest = DAL.OrderedComponent.GetOrderedComponent(unitGuid);

			Assert.AreEqual(22, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderedComponentGuid), TABLES.OrderedComponent.OrderedComponentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.PatientOrderGuid), TABLES.OrderedComponent.PatientOrderGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.ComponentClassId), TABLES.OrderedComponent.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.CprsOrderNumber), TABLES.OrderedComponent.CprsOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.VbecsOrderNumber), TABLES.OrderedComponent.VbecsOrderNumber);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.RequiredUnitQuantity), TABLES.OrderedComponent.RequiredUnitQuantity);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.SpecimenRequiredIndicator), TABLES.OrderedComponent.SpecimenRequiredIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.PatientSpecimenGuid), TABLES.OrderedComponent.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.SpecimenStatusCode), TABLES.OrderedComponent.SpecimenStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.PreOpIndicator), TABLES.OrderedComponent.PreOpIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderStatusCode), TABLES.OrderedComponent.OrderStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderUrgencyCode), TABLES.OrderedComponent.OrderUrgencyCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.RequiredDatetime), TABLES.OrderedComponent.RequiredDatetime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderSpecialInstructions), TABLES.OrderedComponent.OrderSpecialInstructions);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.OrderedComponentComments), TABLES.OrderedComponent.OrderedComponentComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.CancellationCannedCommentGuid), TABLES.OrderedComponent.CancellationCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.InappropriateRequestIndicator), TABLES.OrderedComponent.InappropriateRequestIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.TaskStatusCode), TABLES.OrderedComponent.TaskStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.DivisionCode), TABLES.OrderedComponent.DivisionCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.LastUpdateDate), TABLES.OrderedComponent.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.LastUpdateUser), TABLES.OrderedComponent.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.RowVersion), TABLES.OrderedComponent.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetOrderedComponent_Fail()
		{
			DAL.OrderedComponent.GetOrderedComponent(System.Guid.Empty);
		}

		[Test]
		public void GetBloodUnitTestResultsForOrderedComponent_Guid_Guid_Pass()
		{
			
			DataTable dtTest = DAL.OrderedComponent.GetBloodUnitTestResultsForOrderedComponent(System.Guid.NewGuid(), System.Guid.NewGuid());
			
			Assert.AreEqual(27, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), TABLES.PatientSpecimen.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.OrderedComponentGuid), TABLES.BloodUnitTest.OrderedComponentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitTestGuid), TABLES.BloodUnitTest.BloodUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.OrderedUnitGuid), TABLES.BloodUnitTest.OrderedUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestingMethodCode), TABLES.BloodUnitTest.TestingMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.TestingMethodText), TABLES.TestingMethod.TestingMethodText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RackGuid), TABLES.BloodUnitTest.RackGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.TestedWith), TABLES.BloodTestType.TestedWith);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodTestTypeId), TABLES.BloodUnitTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), TABLES.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.Phase), TABLES.BloodTestType.Phase);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.SortColumn), TABLES.BloodTestType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestResultId), TABLES.BloodUnitTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestTechId), TABLES.BloodUnitTest.TestTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestDate), TABLES.BloodUnitTest.TestDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestComments), TABLES.BloodUnitTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.AutoInstrumentName), TABLES.BloodUnitTest.AutoInstrumentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RecordStatusCode), TABLES.BloodUnitTest.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.InactivateUser), TABLES.BloodUnitTest.InactivateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.InactivateDate), TABLES.BloodUnitTest.InactivateDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RowVersion), TABLES.BloodUnitTest.RowVersion);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PendingBloodUnitTest.UnitResultSetGuid), TABLES.PendingBloodUnitTest.UnitResultSetGuid);
		}

		[Test]
		public void GetBloodUnitTestResultsForOrderedComponent_Guid_Guid_Fail()
		{
			try
			{
				DataTable dtTest = DAL.OrderedComponent.GetBloodUnitTestResultsForOrderedComponent(Guid.Empty, Guid.NewGuid());
				Assert.AreEqual(true, false, "1" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.AreEqual(true, true, "Pass1");
			}

			try
			{
				DataTable dtTest = DAL.OrderedComponent.GetBloodUnitTestResultsForOrderedComponent(System.Guid.NewGuid(), Guid.Empty);
				Assert.AreEqual(true, false, "2-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.AreEqual(true, true, "Pass2");
			}

		}

		[Test]
		public void GetRequiredOrders_Pass()
		{
			int requiredHours = 24;
			DateTime lastChecked = VbecsDateTime.GetDivisionCurrentDateTime().Subtract(new TimeSpan(777, 0, 0, 0, 0));

			DataTable dtTest = DAL.OrderedComponent.GetRequiredOrders(UnitTestConfig.TestDivisionCode, requiredHours, lastChecked);
			
			//If we didn't crash, we're a success
			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(11, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderUrgency.OrderUrgencyText), TABLES.OrderUrgency.OrderUrgencyText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.OrderedItem), ARTIFICIAL.OrderedItem);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.WantedDate), ARTIFICIAL.WantedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.CprsOrderNumber), TABLES.OrderedComponent.CprsOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.LabOrderNumber), TABLES.OrderedComponent.LabOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.DatabaseConstants.ArtificialColumnNames.UrgencySortColumn), Common.DatabaseConstants.ArtificialColumnNames.UrgencySortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.DatabaseConstants.ArtificialColumnNames.RequestSortColumn), Common.DatabaseConstants.ArtificialColumnNames.RequestSortColumn);
		}

		[Test]
		public void GetRequiredOrders_Fail1()
		{
			try
			{
				DataTable dtTest = DAL.OrderedComponent.GetRequiredOrders(string.Empty, 1,System.DateTime.Now);
				Assert.AreEqual(true, false, "1-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.AreEqual(true, true, "1-ReturnValue");
			}

			try
			{
				DataTable dtTest = DAL.OrderedComponent.GetRequiredOrders(null, 1, System.DateTime.Now);
				Assert.AreEqual(true, false, "2-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.AreEqual(true, true, "2-ReturnValue");
			}

			try
			{
				System.DateTime checkDate = new System.DateTime();
				DataTable dtTest = DAL.OrderedComponent.GetRequiredOrders(UnitTestConfig.TestDivisionCode, 1, checkDate);
				Assert.AreEqual(true, false, "3-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.AreEqual(true, true, "3-ReturnValue");
			}
			
			try
			{
				DataTable dtTest = DAL.OrderedComponent.GetRequiredOrders(UnitTestConfig.TestDivisionCode, -1, System.DateTime.Now);
				Assert.AreEqual(true, false, "4-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.AreEqual(true, true, "4-ReturnValue");
			}
		}

		[Test]
		public void GetOrdersWithSpecimenInBloodBank_Pass()
		{
			DateTime lastChecked = VbecsDateTime.GetDivisionCurrentDateTime().Subtract(new TimeSpan(777, 0, 0, 0, 0));
			DataTable dtTest = DAL.OrderedComponent.GetOrdersWithSpecimenInBloodBank(UnitTestConfig.TestDivisionCode, lastChecked);

			//If we didn't crash, we're a success
			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(11, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderUrgency.OrderUrgencyText), TABLES.OrderUrgency.OrderUrgencyText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.OrderedItem), ARTIFICIAL.OrderedItem);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.WantedDate), ARTIFICIAL.WantedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.CprsOrderNumber), TABLES.OrderedComponent.CprsOrderNumber);	
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.LabOrderNumber), TABLES.OrderedComponent.LabOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.DatabaseConstants.ArtificialColumnNames.UrgencySortColumn), Common.DatabaseConstants.ArtificialColumnNames.UrgencySortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.DatabaseConstants.ArtificialColumnNames.RequestSortColumn), Common.DatabaseConstants.ArtificialColumnNames.RequestSortColumn);

		}

		[Test]
		public void GetOrdersWithSpecimenInBloodBank_Fail()
		{
			//Test DivisionCode
			try
			{
				DAL.OrderedComponent.GetOrdersWithSpecimenInBloodBank(string.Empty, System.DateTime.Now);
				Assert.Fail("Invalid DivisionCode");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Invalid DivisionCode");
			}

			//Test Date
			try
			{
				DAL.OrderedComponent.GetOrdersWithSpecimenInBloodBank(this.TestDivisionCode, new DateTime());
				Assert.Fail("Invalid Date");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Invalid Date");
			}

		}

		[Test]
		public void GetNewOrders_Pass()
		{
			DateTime lastChecked = VbecsDateTime.GetDivisionCurrentDateTime().AddYears(-10);
			DataTable dtTest = DAL.OrderedComponent.GetNewOrders(UnitTestConfig.TestDivisionCode, lastChecked);
			
			//If we didn't crash, we're a success
			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(11, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderUrgency.OrderUrgencyText), TABLES.OrderUrgency.OrderUrgencyText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.OrderedItem), ARTIFICIAL.OrderedItem);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.WantedDate), ARTIFICIAL.WantedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.CprsOrderNumber), TABLES.OrderedComponent.CprsOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedComponent.LabOrderNumber), TABLES.OrderedComponent.LabOrderNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.DatabaseConstants.ArtificialColumnNames.UrgencySortColumn), Common.DatabaseConstants.ArtificialColumnNames.UrgencySortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(Common.DatabaseConstants.ArtificialColumnNames.RequestSortColumn), Common.DatabaseConstants.ArtificialColumnNames.RequestSortColumn);
		}

		[Test]
		public void GetNewOrders_Fail()
		{
			//Test DivisionCode
			try
			{
				DAL.OrderedComponent.GetNewOrders(string.Empty, System.DateTime.Now);
				Assert.Fail("Invalid DivisionCode");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Invalid DivisionCode");
			}

			//Test Date
			try
			{
				DAL.OrderedComponent.GetNewOrders(this.TestDivisionCode, new DateTime());
				Assert.Fail("Invalid Date");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Invalid Date");
			}
		}


		[Test]
		public void GetOrderedComponentQuantity_Pass()
		{
			System.Guid ocGuid = (System.Guid)this._dtOrderedComponent.Rows[0][TABLES.OrderedComponent.OrderedComponentGuid];

			int retValue = DAL.OrderedComponent.GetOrderedComponentQuantity(ocGuid);

			Assert.AreEqual(true, retValue >= 0, "Count");
		}

		
		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetOrderedComponentQuantity_Fail()
		{
			DAL.OrderedComponent.GetOrderedComponentQuantity(System.Guid.Empty);
		}
	}
}
#endif

